/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.handlers;

import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.MCFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.createtweaker.CreateTweaker;
import com.mojang.datafixers.util.Either;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.components.mixer.CompactingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeSerializer;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;

@IRecipeHandler.For(value=CompactingRecipe.class)
public class CompactingRecipeHandler
implements IRecipeHandler<CompactingRecipe> {
    public String dumpToCommandString(IRecipeManager iRecipeManager, CompactingRecipe recipe) {
        Either result = !recipe.getFluidResults().isEmpty() ? Either.right((Object)new MCFluidStack((FluidStack)recipe.getFluidResults().get(0))) : Either.left(recipe.getRollableResults().stream().map(CreateTweaker::mapProcessingResult));
        return String.format("<recipetype:create:compacting>.addRecipe(\"%s\", <constant:create:heat_condition:%s>, [%s], [%s], [%s]);", recipe.m_6423_(), recipe.getRequiredHeat().name().toLowerCase(Locale.ENGLISH), result.map(results -> results.map(Percentaged::getCommandString).collect(Collectors.joining(", ")), CommandStringDisplayable::getCommandString), recipe.m_7527_().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ")), recipe.getFluidResults().stream().map(MCFluidStack::new).map(MCFluidStack::getCommandString).collect(Collectors.joining(", ")));
    }

    public Optional<Function<ResourceLocation, CompactingRecipe>> replaceIngredients(IRecipeManager manager, CompactingRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList((NonNullList)recipe.m_7527_(), Ingredient.class, (Recipe)recipe, rules, newIngredients -> id -> {
            ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(((ProcessingRecipeSerializer)AllRecipeTypes.COMPACTING.getSerializer()).getFactory(), id);
            builder.withItemOutputs((ProcessingOutput[])recipe.getRollableResults().toArray(ProcessingOutput[]::new));
            builder.withItemIngredients(newIngredients);
            builder.withFluidIngredients(recipe.getFluidIngredients());
            builder.requiresHeat(recipe.getRequiredHeat());
            builder.duration(recipe.getProcessingDuration());
            return (CompactingRecipe)builder.build();
        });
    }
}

